/*
 * Decompiled with CFR 0.152.
 */
package de.willuhn.jameica.gui.internal.dialogs;

import de.willuhn.jameica.gui.Action;
import de.willuhn.jameica.gui.boxes.Box;
import de.willuhn.jameica.gui.boxes.BoxRegistry;
import de.willuhn.jameica.gui.dialogs.AbstractDialog;
import de.willuhn.jameica.gui.formatter.TableFormatter;
import de.willuhn.jameica.gui.internal.action.Start;
import de.willuhn.jameica.gui.parts.Button;
import de.willuhn.jameica.gui.parts.ButtonArea;
import de.willuhn.jameica.gui.parts.TableChangeListener;
import de.willuhn.jameica.gui.parts.TablePart;
import de.willuhn.jameica.gui.parts.table.FeatureSummary;
import de.willuhn.jameica.gui.util.Color;
import de.willuhn.jameica.gui.util.SimpleContainer;
import de.willuhn.jameica.messaging.StatusBarMessage;
import de.willuhn.jameica.system.Application;
import de.willuhn.jameica.system.OperationCanceledException;
import de.willuhn.logging.Logger;
import de.willuhn.util.ApplicationException;
import java.rmi.RemoteException;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.TableItem;

public class ChooseBoxesDialog
extends AbstractDialog {
    private TablePart table = null;
    private Button down = null;
    private Button up = null;

    public ChooseBoxesDialog(int position) {
        super(position);
        this.setTitle(this.i18n.tr("Auswahl der anzuzeigenden Elemente"));
    }

    @Override
    protected void paint(Composite parent) throws Exception {
        List<Box> boxes = BoxRegistry.getBoxes();
        SimpleContainer c = new SimpleContainer(parent, true);
        c.addText(this.i18n.tr("W\u00e4hlen Sie die anzuzeigenden Elemente aus."), true);
        this.table = new TablePart(boxes, null){

            @Override
            protected Control getEditorControl(int row, TableItem item, String oldValue) {
                String validChars = "0123456789";
                Control c = super.getEditorControl(row, item, oldValue);
                c.addListener(25, new Listener(){

                    public void handleEvent(Event e) {
                        char[] chars = e.text.toCharArray();
                        for (int i = 0; i < chars.length; ++i) {
                            if ("0123456789".indexOf(chars[i]) != -1) continue;
                            e.doit = false;
                            return;
                        }
                    }
                });
                return c;
            }
        };
        this.table.addColumn(this.i18n.tr("Bezeichnung"), "name");
        this.table.addColumn(this.i18n.tr("H\u00f6he des Elements"), "height", null, true, 131072);
        this.table.setCheckable(true);
        this.table.setMulti(false);
        this.table.removeFeature(FeatureSummary.class);
        this.table.setRememberOrder(false);
        this.table.setFormatter(new TableFormatter(){

            @Override
            public void format(TableItem item) {
                if (item == null || item.getData() == null) {
                    return;
                }
                Box box = (Box)item.getData();
                item.setChecked(box.isEnabled());
                int height = BoxRegistry.getHeight(box);
                item.setText(1, height > 0 ? Integer.toString(height) : "");
                if (!box.isActive()) {
                    item.setForeground(Color.COMMENT.getSWTColor());
                    item.setGrayed(true);
                } else {
                    item.setForeground(Color.FOREGROUND.getSWTColor());
                }
            }
        });
        this.table.addSelectionListener(new Listener(){

            public void handleEvent(Event event) {
                Box b = (Box)event.data;
                if (b == null) {
                    return;
                }
                boolean active = b.isActive();
                ChooseBoxesDialog.this.up.setEnabled(active);
                ChooseBoxesDialog.this.down.setEnabled(active);
            }
        });
        this.table.addChangeListener(new TableChangeListener(){

            @Override
            public void itemChanged(Object object, String attribute, String newValue) throws ApplicationException {
                if (object == null) {
                    return;
                }
                int i = -1;
                try {
                    if (StringUtils.isNotEmpty((String)newValue)) {
                        i = Integer.parseInt(newValue);
                    }
                }
                catch (Exception e) {
                    Logger.warn((String)("invalid height given: " + newValue));
                    return;
                }
                BoxRegistry.setHeight((Box)object, i);
            }
        });
        c.addPart(this.table);
        ButtonArea buttons = new ButtonArea();
        this.up = new Button(this.i18n.tr("Nach oben"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                Box box = (Box)ChooseBoxesDialog.this.table.getSelection();
                if (box == null) {
                    return;
                }
                try {
                    List checked = ChooseBoxesDialog.this.table.getItems(true);
                    int index = ChooseBoxesDialog.this.table.removeItem(box);
                    if (index == -1) {
                        return;
                    }
                    ChooseBoxesDialog.this.table.addItem((Object)box, index == 0 ? 0 : index - 1);
                    ChooseBoxesDialog.this.table.select(box);
                    ChooseBoxesDialog.this.table.setChecked(box, checked.contains(box));
                }
                catch (Exception e) {
                    Logger.error((String)"Fehler beim Verschieben des Elementes", (Throwable)e);
                }
            }
        }, null, false, "maximize.png");
        this.down = new Button(this.i18n.tr("Nach unten"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                Box box = (Box)ChooseBoxesDialog.this.table.getSelection();
                if (box == null) {
                    return;
                }
                try {
                    List checked = ChooseBoxesDialog.this.table.getItems(true);
                    int index = ChooseBoxesDialog.this.table.removeItem(box);
                    if (index == -1) {
                        return;
                    }
                    int size = ChooseBoxesDialog.this.table.size();
                    if (index < size) {
                        ++index;
                    }
                    ChooseBoxesDialog.this.table.addItem((Object)box, index);
                    ChooseBoxesDialog.this.table.select(box);
                    ChooseBoxesDialog.this.table.setChecked(box, checked.contains(box));
                }
                catch (Exception e) {
                    Logger.error((String)"Fehler beim Verschieben des Elementes", (Throwable)e);
                }
            }
        }, null, false, "minimize.png");
        buttons.addButton(this.up);
        buttons.addButton(this.down);
        buttons.addButton(this.i18n.tr("\u00dcbernehmen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                try {
                    List boxes = ChooseBoxesDialog.this.table.getItems(false);
                    List checked = ChooseBoxesDialog.this.table.getItems(true);
                    for (int i = 0; i < boxes.size(); ++i) {
                        Box box = (Box)boxes.get(i);
                        box.setIndex(i);
                        box.setEnabled(checked.contains(box));
                    }
                }
                catch (RemoteException re) {
                    Logger.error((String)"unable to apply box states", (Throwable)re);
                    Application.getMessagingFactory().sendMessage(new StatusBarMessage(Application.getI18n().tr("Fehler beim Speichern: {0}", re.getMessage()), 1));
                }
                ChooseBoxesDialog.this.close();
                new Start().handleAction(context);
            }
        }, null, true, "ok.png");
        buttons.addButton(this.i18n.tr("Abbrechen"), new Action(){

            @Override
            public void handleAction(Object context) throws ApplicationException {
                throw new OperationCanceledException();
            }
        }, null, false, "process-stop.png");
        c.addButtonArea(buttons);
        this.getShell().setMinimumSize(550, 400);
        this.getShell().setSize(this.getShell().computeSize(550, -1));
    }

    protected Object getData() throws Exception {
        return null;
    }
}

